/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.spawn_criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.silverminer.shrines.registries.SpawnCriteriaTypeRegistry;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteria;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteriaType;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class CloseToStructureSpawnCriteria
extends SpawnCriteria {
    public static final Codec<CloseToStructureSpawnCriteria> CODEC = RecordCodecBuilder.create(closeToStructureSpawnCriteriaInstance -> closeToStructureSpawnCriteriaInstance.group((App)StructureSet.f_210002_.fieldOf("structure_set").forGetter(CloseToStructureSpawnCriteria::getStructureSetHolder), (App)Codec.intRange((int)0, (int)32).fieldOf("max_chunk_distance").forGetter(CloseToStructureSpawnCriteria::getMaxChunkDistance)).apply((Applicative)closeToStructureSpawnCriteriaInstance, CloseToStructureSpawnCriteria::new));
    private final Holder<StructureSet> structureSetHolder;
    private final int maxChunkDistance;

    public CloseToStructureSpawnCriteria(Holder<StructureSet> structureSetHolder, int maxChunkDistance) {
        this.structureSetHolder = structureSetHolder;
        this.maxChunkDistance = maxChunkDistance;
    }

    private static boolean hasFeatureChunkInRange(StructureSet structureSet, int chunkX, int chunkZ, int range, ChunkGenerator chunkGenerator) {
        if (structureSet != null) {
            StructurePlacement structureplacement = structureSet.f_210004_();
            for (int i = chunkX - range; i <= chunkX + range; ++i) {
                for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                    if (!structureplacement.m_212129_(chunkGenerator, (long)range, i, j)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public SpawnCriteriaType getType() {
        return (SpawnCriteriaType)((Object)SpawnCriteriaTypeRegistry.CLOSE_TO_STRUCTURE.get());
    }

    @Override
    public boolean test(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, ChunkPos chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, StructureManager structureManager, RegistryAccess registryAccess) {
        return CloseToStructureSpawnCriteria.hasFeatureChunkInRange((StructureSet)this.getStructureSetHolder().m_203334_(), chunkPos.f_45578_, chunkPos.f_45579_, this.getMaxChunkDistance(), chunkGenerator);
    }

    protected Holder<StructureSet> getStructureSetHolder() {
        return this.structureSetHolder;
    }

    protected int getMaxChunkDistance() {
        return this.maxChunkDistance;
    }
}

